
function [outI1, outI2, A1, A2] = colourHAugment(I1,I2,A1,A2, hueStdDev)
%COLOURAUGMENT Recolour both images independently by 
% shifting the RGB channels a random amount sampled from gaussian

% I1 and I2 are 3-channel images (RGB)
% A1 and A2 are the annotations (YOLO bounding boxes)
    HSV1 = rgb2hsv(I1);
    HSV2 = rgb2hsv(I2);
    HSV1(:,:,1) = imadd(HSV1(:,:,1), abs(normrnd(0, hueStdDev)));
    HSV2(:,:,1) = imadd(HSV2(:,:,1), abs(normrnd(0, hueStdDev)));
    outI1 = uint8(hsv2rgb(HSV1)*255);
    outI2 = uint8(hsv2rgb(HSV2)*255);
    outI1 = applyMask(outI1, I1);
    outI2 = applyMask(outI2, I2);
end

